<?php

// Include Google Cloud dependendencies using Composer
require_once __DIR__ . '/vendor/autoload.php';

use Google\Cloud\Kms\V1\KeyManagementServiceClient;

 /*$projectId = 'wealthsharing';
 $locationId = 'global';
 $keyRingId = 'wss_key_ring';
 $cryptoKeyId = 'client_key';*/
 $projectId = 'wealthsharing';
 $locationId = 'global';
 $keyRingId = 'test';
 $cryptoKeyId = 'codelab';
 $ciphertextFileName = '/home/ondemand/test.ondemandpro.net/cipher';
 $plaintextFileName = '/home/ondemand/test.ondemandpro.net/plain';

$kms = new KeyManagementServiceClient();

echo 'Permissions <br>';
// The resource name of the Key Ring.
$keyRingName = $kms->keyRingName($projectId, $locationId, $keyRingId);
// Get the Key Ring Policy and print it.
$keyRingPolicy = $kms->getIamPolicy($keyRingName);
foreach ($keyRingPolicy->getBindings() as $binding) {
    printf("Role: %s\nMembers:\n", $binding->getRole());
    foreach ($binding->getMembers() as $member) {
        printf("  %s\n", $member);
    }
    print("\n");
}

// The resource name of the CryptoKey.
$cryptoKeyName = $kms->cryptoKeyName($projectId, $locationId, $keyRingId, $cryptoKeyId);

$plaintext = file_get_contents($plaintextFileName);
$response = $kms->encrypt($cryptoKeyName, $plaintext);

// Write the encrypted text to a file.
file_put_contents($ciphertextFileName, $response->getCiphertext());
printf('Saved encrypted text to %s' . PHP_EOL, $ciphertextFileName);


?>