<?php

echo 'a'; exit;

require_once __DIR__ . '/../vendor/autoload.php'; 

use Google_Service_CloudKMS as Kms;
use Google_Service_CloudKMS_DecryptRequest as DecryptRequest;
use Google_Service_CloudKMS_EncryptRequest as EncryptRequest;

class KeyManager
{
    private $kms;
    private $encryptRequest;
    private $decryptRequest;
    private $projectId;
    private $locationId;
    private $keyRingId;
    private $cryptoKeyId;

    public function __construct(Kms $kms, EncryptRequest $encryptRequest, DecryptRequest $decryptRequest, $projectId, $locationId, $keyRingId, $cryptoKeyId)
    {
        $this->kms            = $kms;
        $this->encryptRequest = $encryptRequest;
        $this->decryptRequest = $decryptRequest;
        $this->projectId      = $projectId;
        $this->locationId     = $locationId;
        $this->keyRingId      = $keyRingId;
        $this->cryptoKeyId    = $cryptoKeyId;
    }

    public function encrypt($data)
    {
        $key        = random_bytes(SODIUM_CRYPTO_SECRETBOX_KEYBYTES);
        $nonce      = random_bytes(SODIUM_CRYPTO_SECRETBOX_NONCEBYTES);
        $ciphertext = sodium_crypto_secretbox($data, $nonce, $key);

        return [
            'data'   => base64_encode($nonce . $ciphertext),
            'secret' => $this->encryptKey($key),
        ];
    }

    public function decrypt($secret, $data)
    {
        $decoded    = base64_decode($data);
        $key        = $this->decryptSecret($secret);
        $nonce      = mb_substr($decoded, 0, SODIUM_CRYPTO_SECRETBOX_NONCEBYTES, '8bit');
        $ciphertext = mb_substr($decoded, SODIUM_CRYPTO_SECRETBOX_NONCEBYTES, null, '8bit');

        return sodium_crypto_secretbox_open($ciphertext, $nonce, $key);
    }

    private function encryptKey($key)
    {
        $this->encryptRequest->setPlaintext(base64_encode($key));

        $response = $this->kms->projects_locations_keyRings_cryptoKeys->encrypt(
            $this->getResourceName(),
            $this->encryptRequest
        );

        return $response['ciphertext'];
    }

    private function decryptSecret($secret)
    {
        $this->decryptRequest->setCiphertext($secret);

        $response = $this->kms->projects_locations_keyRings_cryptoKeys->decrypt(
            $this->getResourceName(),
            $this->decryptRequest
        );

        return base64_decode($response['plaintext']);
    }

    private function getResourceName()
    {
        return sprintf(
            'projects/%s/locations/%s/keyRings/%s/cryptoKeys/%s',
            $this->projectId,
            $this->locationId,
            $this->keyRingId,
            $this->cryptoKeyId
        );
    }
}


$client = new Google_Client();
$client->setAuthConfig(getenv('GOOGLE_CREDENTIALS_FILE'));
$client->addScope('https://www.googleapis.com/auth/cloud-platform');

$keyManager = new KeyManager(
    new Kms($client),
    new EncryptRequest(),
    new DecryptRequest(),
    $projectId,
    $locationId,
    $keyRingId,
    $cryptoKeyId
);

$encrypted = $keyManager->encrypt('This is a secret!');
var_dump($encrypted);

// array (size=2)
//     'data' => string 'uKjmEU7e1JEU+2vL3hBK2wBk6afCSgb+Y4GQtu/mmLuffgHlnqxnqOMPOI6WGkM18vAGGvFVDTvd' (length=76)
//     'secret' => string 'CiQAdA0emUW2nhlU3RijX/5GnUsTnPPrQdLZNxdHWXWYugx49a4SSQBHyYr0T/PEbKwyFhIkaZl28oKkJRkXqNcqOL4Z+OTQFLpGvS6zCDt2mFn/nUQ/bi4znD4DORk9ZDTqiIBK3UNFUZcrXvoExds=' (length=152)

$decrypted = $keyManager->decrypt($encrypted['secret'], $encrypted['data']);
var_dump($decrypted);

// string 'This is a secret!' (length=17)


?>